﻿/*
VERSION:		1.5

DESCRIPTION:
	Places and removes sprites based on their flag conditions.
	This can also be used to initially place sprites when a level is loaded.

USAGE:
	// remember all sprites in a new array
	sprites_mc.spritesRemaining = [];
	for(var s=0; s<levelData.sprites.length; s++){
		sprites_mc.spritesRemaining.push( levelData.sprites[s] );
	}// for:  each spriteData
	sprites_mc.spritesRemaining.remove = function( thisSprite )
	{// remove()
		for(var s in sprites_mc.spritesRemaining){
			if(sprites_mc.spritesRemaining[s] == thisSprite){
				sprites_mc.spritesRemaining.splice( s, 1 );
			}// if:  targeted sprite is found
		}// for:  each remaining sprite
	}// remove()
	// call  spritesRemaining.remove()  when a sprite is removed from play
	
	
	#include "functions/updateFlaggedSprites.as"
	#include "functions/nextDepth.as"
	sprites_mc.updateSprites = function( focusOnFlag ){
		var addSprite = function( thisSprite ){
			if(sprites_mc[thisSprite.name] == undefined)
			{// if:  this sprite doesn't exist
				var type = thisSprite.type;
				var newName = thisSprite.name;
				var newDepth = nextDepth(sprites_mc);
				var newX = thisSprite.position.x;
				var newY = thisSprite.position.y;
				var settings = thisSprite.data;
				var newSprite = sprites_mc.attachMovie(type, newName, newDepth, {_x:newX, _y:newY, data:thisSprite, settings:settings});
				newSprite.remove = function(){// remove()
					sprites_mc.spritesRemaining.remove( this.data );
					this.removeMovieClip();
				}// remove()
			}// if:  this sprite doesn't exist
		}// addSprite()
		var removeSprite = function( thisSprite ){
			sprites_mc[thisSprite.name].removeMovieClip();
		}// removeSprite()
		var showSprites = updateFlaggedSprites( sprites_mc.spritesRemaining, ram, addSprite, removeSprite, focusOnFlag );
	}// updateSprites()

	
	
	
	
POSSIBLE DISPLAY VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(same as not including it)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973
	
POSSIBLE FLAG VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(not whether it's false, whether it's nonexistant)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973

PARAMETERS:
	sprites				Array of sprite data  (not movieClips)
	flagRoot			Object containing all the flag variables & their sub-objects
	addSprite			function to run when a sprite's flags are all true  (Might run more than once)
	removeSprite	function to run when one of a sprite's flags is false and it should no longer exist  (Might run more than once)
*/
updateFlaggedSprites = function( sprites, flagRoot, addSprite, removeSprite )
{
	// _______________________________________________________________________________
	var getFlagParts = function( flag )
	{// convert "myFlag" to "myFlag != undefined"		"!myFlag" to "myFlag = undefined"		"myFlag>2" to "myFlag > 2"
		var parts_array = [];
		
		// remove space from beginning of flag
		var firstChar = flag.charAt(0);
		while(firstChar==" "){
			flag = flag.substr(1);		// chop off first character
			firstChar = flag.charAt(0);
		}// while:  space exists at the beginning
		
		
		// remove space from end of flag
		var lastChar = flag.charAt( flag.length-1 );
		while(lastChar==" "){
			flag = flag.substr(0, flag.length-1);		// chop off last character
			lastChar = flag.charAt( flag.length-1 );
		}// while:  space exists at the end
		
		
		// catch:  !myFlag
		if( flag.charAt(0) == "!" ){
			flag = flag.substr(1)+"!";
			var endAt = flag.indexOf("!");
			var startAt = endAt+1;
		}// if:  flag starts with !
		else if( flag.indexOf("!=") != -1 ){
			var endAt = flag.indexOf("!=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<=") != -1 ){
			var endAt = flag.indexOf("<=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf(">=") != -1 ){
			var endAt = flag.indexOf(">=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<") != -1 ){
			var endAt = flag.indexOf("<");
			var startAt = endAt+1;
		}
		else if( flag.indexOf(">") != -1 ){
			var endAt = flag.indexOf(">");
			var startAt = endAt+1;
		}
		else if( flag.indexOf("=") != -1 ){
			var endAt = flag.indexOf("=");
			var startAt = endAt+1;
		}
		else{// if:  there's no operator
			var endAt = flag.length;
			flag = flag+"!=undefined"
			var startAt = endAt+2;
		}// if:  there's no operator
		
		parts_array.push(flag.substr( 0, endAt ));					// [0]	myFlag
		parts_array.push(flag.substring( endAt, startAt ));	// [1]	!=
		parts_array.push(flag.substr( startAt ));						// [2]	"merf"
		
		// remove space from end of flag name
		var lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		while(lastChar==" "){
			parts_array[0] = parts_array[0].substr(0, parts_array[0].length-1);		// chop off last character
			lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		}// while:  space exists at the end
		// remove space from beginning of value
		var firstChar = parts_array[2].charAt(0);
		while(firstChar==" "){
			parts_array[2] = parts_array[2].substr(1);		// chop off first character
			firstChar = parts_array[2].charAt(0);
		}// while:  space exists at the beginning
		
		return parts_array;
	}// getFlagParts()
	
	
	
	var checkFlag = function( spriteFlag, flagRoot )
	{
		var output = true;			// returns boolean "false" when a flag fails a test
		var flagParts_array = getFlagParts( spriteFlag );
		var variable = flagParts_array[0];
		var operation = flagParts_array[1];
		var value = flagParts_array[2];
		
		// convert value into likely datatype
		// // number
		if( isNaN(value)==false )
			value = Number(value);
		// // boolean
		if( value=="true" )
			value = true;
		if( value=="false" )
			value = false;
		// // undefined
		if( value=="undefined" )
			value = undefined;
		// // string
		// already a string by default
		
		// separate variable name from variable path
		var endAt = variable.lastIndexOf(".");
		if( endAt != -1 )
		{// if:  there is an object path
			var flagPath = variable.substr(0, endAt);			// myObj.anotherObject
			var flagName = variable.substr( endAt+1 );		// myVar
			var flagPath = "flagRoot."+flagPath;					// flagRoot.myObj.anotherObject
		}// if:  there is an object path
		else
		{// if:  there are no preceeding objects
			var flagName = variable;
			var flagPath = "flagRoot";
		}// if:  there are no preceeding objects
		var displayValue = eval(flagPath+"."+flagName);
		
		// check specified contents, in the specified ways
		switch( operation )
		{
			case "!":
				output = ( displayValue == undefined  ||  displayValue == false );		// these values return as true
				//trace("  displayValue: "+displayValue+"  ("+typeof(displayValue)+")  =  "+output);
			break;
			case "=":
				output = ( displayValue == value );
			break;
			case "!=":
				// read "myVar != undefined" as TRUE when   myVar actually equals "false"
				if( !Boolean(displayValue) && !Boolean(value) ){
					displayValue = false;
					value = false;
				}
				output = ( displayValue != value );
			break;
			case "<":
				output = ( displayValue < value );
				if(displayValue==undefined){	output=false		};					// undefined normally returns true
				if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
			break;
			case ">":
				output = ( displayValue > value );
				if(displayValue==undefined){	output=false		};					// undefined normally returns true
				if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
			break;
			case "<=":
				output = ( displayValue <= value );
				if(displayValue==undefined){	output=false		};					// undefined normally returns true
				if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
			break;
			case ">=":
				output = ( displayValue >= value );
				if(displayValue==undefined){	output=false		};					// undefined normally returns true
				if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
			break;
		}// case:  operation
		
		
//		trace("\t\t "+output+" ("+displayValue+" "+operation+" "+value+")" );
		return output;
	}// checkFlag()
	// _______________________________________________________________________________
	
	
	
	// check sprites
	for( var s=0; s<sprites.length; s++)
	{// for:  each sprite
		var thisSprite = sprites[s];
//		trace("sprite: "+thisSprite.name);
		
		var testResult = true;		// sprite will display, unless there's a reason not to
		
		for( var sf=0; sf<thisSprite.flags.length; sf++ )
		{// for:  each of this sprite's flags
			var thisSpriteFlag = thisSprite.flags[sf];
//			trace("\t checking:  "+thisSpriteFlag);
			testResult = checkFlag( thisSpriteFlag, flagRoot );		// decide whether to add it or remove it
			if(testResult==false)
				break;		// the moment a test fails, stop checking
		}// for:  each of this sprite's flags
		
		if(testResult==true){						// add
			addSprite( thisSprite );
		}else if(testResult==false){		// remove
			removeSprite( thisSprite );
		}
	}// for:  each sprite
}// updateFlaggedSprites()